// --
// Copyright (C) 2001-2021 OTRS AG, https://otrs.com/
// Copyright (C) 2021-2022 Znuny GmbH, https://znuny.org/
// --
// This software comes with ABSOLUTELY NO WARRANTY. For details, see
// the enclosed file COPYING for license information (GPL). If you
// did not receive this file, see https://www.gnu.org/licenses/gpl-3.0.txt.
// --

"use strict";

(function () {

    /**
     * @name isJQueryObject
     * @memberof window
     * @function
     * @returns {Boolean} Returns true if all parameter objects are jQuery objects, false otherwise.
     * @description
     *      This function checks if all given parameter objects are jQuery objects.
     */
    window.isJQueryObject = function () {
        var I;
        if (typeof jQuery === 'undefined') {
            return false;
        }
        for (I = 0; I < arguments.length; I++) {
            if (!(arguments[I] instanceof jQuery)) {
                return false;
            }
        }
        return true;
    };
}());

// taken from: http://stackoverflow.com/a/2641047
// [name] is the name of the event "click", "mouseover", ..
// same as you'd pass it to on()
// [fn] is the handler function
$.fn.unshiftOn = function(name, fn) {
    // on as you normally would
    // don't want to miss out on any jQuery magic
    this.on(name, fn);

    // Thanks to a comment by @Martin, adding support for
    // namespaced events too.
    this.each(function() {
        var handlers = $._data(this, 'events')[name.split('.')[0]];

        // take out the handler we just inserted from the end
        var handler = handlers.pop();
        // move it at the beginning
        handlers.splice(0, 0, handler);
    });
};
