#!/bin/bash

# This file is sourced by other bash scripts

# Whether we should also package the versions marked as obsolete in repository2-1.xml
SKIP_OBSOLETE_PACKAGES=1

# Build List of components to package
if [ $SKIP_OBSOLETE_PACKAGES -eq 1 ]; then
    PLATFORMS_VERSIONS_TO_PACKAGE=$(grep "^platforms;" ../version_list.txt | grep -v --perl-regex "\tobsolete" | sed "s/;/,/g" |  cut -d "	" -f1)
    BUILD_TOOLS_VERSIONS_TO_PACKAGE=$(grep "^build-tools;" ../version_list.txt | grep -v --perl-regex "\tobsolete" | sed "s/;/,/g" | cut -d "	" -f1 | sort)
    PATCHER_VERSIONS_TO_PACKAGE=$(grep "^patcher;" ../version_list.txt | grep -v --perl-regex "\tobsolete" | sed "s/;/,/g" | cut -d "	" -f1 | sort)
    CMDLINE_TOOLS_VERSIONS_TO_PACKAGE=$(grep "^cmdline-tools;[0-9]" ../version_list.txt | grep -v --perl-regex "\tobsolete" | sed "s/;/,/g" | cut -d "	" -f1 | sort)
    PLATFORM_TOOLS_VERSIONS_TO_PACKAGE=$(grep "^platform-tools" ../version_list.txt | grep -v --perl-regex "\tobsolete" | sed "s/;/,/g" | cut -d "	" -f1 | sort -r | head -1)
    NDK_VERSIONS_TO_PACKAGE=$(grep "^ndk;" ../version_list.txt | grep -v --perl-regex "\tobsolete" | sed "s/;/,/g" | cut -d "	" -f1 | sort)
    SOURCES_VERSIONS_TO_PACKAGE=$(grep "^sources;" ../version_list.txt | grep -v --perl-regex "\tobsolete" | sed "s/;/,/g" |  cut -d "	" -f1)
    EMULATOR_VERSIONS_TO_PACKAGE=$(grep "^emulator" ../version_list.txt | grep -v --perl-regex "\tobsolete" | sed "s/;/,/g" | cut -d "	" -f1 | sort -r | head -1)
    EXTRAS_GOOGLE_AUTO_VERSIONS_TO_PACKAGE=$(grep "^extras;google;auto" ../version_list.txt | grep -v --perl-regex "\tobsolete" | sed "s/;/,/g" | cut -d "	" -f1 | sort -r | head -1)
else
    PLATFORMS_VERSIONS_TO_PACKAGE=$(grep "^platforms;" ../version_list.txt | sed "s/;/,/g" |  cut -d "	" -f1)
    BUILD_TOOLS_VERSIONS_TO_PACKAGE=$(grep "^build-tools;" ../version_list.txt | sed "s/;/,/g" | cut -d "	" -f1 | sort)
    PATCHER_VERSIONS_TO_PACKAGE=$(grep "^patcher;" ../version_list.txt | sed "s/;/,/g" | cut -d "	" -f1 | sort)
    CMDLINE_TOOLS_VERSIONS_TO_PACKAGE=$(grep "^cmdline-tools;[0-9]" ../version_list.txt | sed "s/;/,/g" | cut -d "	" -f1 | sort)
    PLATFORM_TOOLS_VERSIONS_TO_PACKAGE=$(grep "^platform-tools" ../version_list.txt | sed "s/;/,/g" | cut -d "	" -f1 | sort -r | head -1)
    NDK_VERSIONS_TO_PACKAGE=$(grep "^ndk;" ../version_list.txt | sed "s/;/,/g" | cut -d "	" -f1 | sort)
    SOURCES_VERSIONS_TO_PACKAGE=$(grep "^sources;" ../version_list.txt | sed "s/;/,/g" |  cut -d "	" -f1)
    EMULATOR_VERSIONS_TO_PACKAGE=$(grep "^emulator" ../version_list.txt | sed "s/;/,/g" | cut -d "	" -f1 | sort -r | head -1)
    EXTRAS_GOOGLE_AUTO_VERSIONS_TO_PACKAGE=$(grep "^extras;google;auto" ../version_list.txt | sed "s/;/,/g" | cut -d "	" -f1 | sort -r | head -1)
fi
