/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.policy.InputModeSelectionPolicy;
import amazon.fws.clicommando.processors.CommandProcessor;
import amazon.fws.clicommando.security.SecurityKeys;
import amazon.fws.clicommando.util.StringUtils;
import java.util.Map;

public class LoadCertPKFilesCommandProcessor
implements CommandProcessor {
    public static final String certFileLocation = "EC2CertFile";
    public static final String privateKeyFileLocation = "EC2PrivateKeyFile";
    public static final String fileEncoding = "String";

    public Command process(Command process) throws CliCommandoException {
        CommandConfig commandConfig = process.getCurrentCommandConfig();
        if (this.parametersConfigured(commandConfig)) {
            boolean privateKeyDefined;
            InputModeSelectionPolicy inputModeSelector = new InputModeSelectionPolicy();
            ParamConfig certParam = commandConfig.getParameter(certFileLocation);
            ParamConfig privateKeyParam = commandConfig.getParameter(privateKeyFileLocation);
            ParamConfig.InputMode inputMode = inputModeSelector.select((T[])new ParamConfig.InputMode[]{privateKeyParam.getInputMode(), certParam.getInputMode()});
            boolean certFileDefined = this.loadFileIntoParameterValue(commandConfig, certFileLocation);
            if (certFileDefined ^ (privateKeyDefined = this.loadFileIntoParameterValue(commandConfig, privateKeyFileLocation))) {
                throw new BadInputException(ErrorMessages.ErrorCode.PARTIAL_KEY_DEFINITION_PROVIDED, new String[0]);
            }
            if (certFileDefined && privateKeyDefined) {
                commandConfig.getSecurityKeys().add(new SecurityKeys(SecurityKeys.KeyType.CERT_PRIVATE_KEY, privateKeyParam.getValue(), certParam.getValue(), inputMode));
            }
        }
        return process;
    }

    private boolean loadFileIntoParameterValue(CommandConfig commandConfig, String paramName) {
        boolean isDefined = true;
        ParamConfig paramConfig = commandConfig.getParameter(paramName);
        if (paramConfig == null) {
            throw new ConfigurationErrorException(paramName + " is not defined");
        }
        String fileName = paramConfig.getValue();
        isDefined = !StringUtils.isEmpty(fileName);
        return isDefined;
    }

    private boolean parametersConfigured(CommandConfig commandConfig) {
        Map<String, ParamConfig> pMap = commandConfig.getParameterMap();
        boolean defined = false;
        if (pMap.containsKey(certFileLocation) && pMap.containsKey(privateKeyFileLocation)) {
            defined = true;
        }
        return defined;
    }
}

