; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+m,+d,+experimental-zfh,+experimental-v -target-abi=ilp32d \
; RUN:     -riscv-v-vector-bits-min=128 -verify-machineinstrs < %s | FileCheck %s --check-prefix=RV32
; RUN: llc -mtriple=riscv64 -mattr=+m,+d,+experimental-zfh,+experimental-v -target-abi=lp64d \
; RUN:     -riscv-v-vector-bits-min=128 -verify-machineinstrs < %s | FileCheck %s --check-prefix=RV64

declare <1 x i8> @llvm.masked.gather.v1i8.v1p0i8(<1 x i8*>, i32, <1 x i1>, <1 x i8>)

define <1 x i8> @mgather_v1i8(<1 x i8*> %ptrs, <1 x i1> %m, <1 x i8> %passthru) {
; RV32-LABEL: mgather_v1i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e8, mf8, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v1i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e8, mf8, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <1 x i8> @llvm.masked.gather.v1i8.v1p0i8(<1 x i8*> %ptrs, i32 1, <1 x i1> %m, <1 x i8> %passthru)
  ret <1 x i8> %v
}

declare <2 x i8> @llvm.masked.gather.v2i8.v2p0i8(<2 x i8*>, i32, <2 x i1>, <2 x i8>)

define <2 x i8> @mgather_v2i8(<2 x i8*> %ptrs, <2 x i1> %m, <2 x i8> %passthru) {
; RV32-LABEL: mgather_v2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e8, mf8, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e8, mf8, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <2 x i8> @llvm.masked.gather.v2i8.v2p0i8(<2 x i8*> %ptrs, i32 1, <2 x i1> %m, <2 x i8> %passthru)
  ret <2 x i8> %v
}

define <2 x i16> @mgather_v2i8_sextload_v2i16(<2 x i8*> %ptrs, <2 x i1> %m, <2 x i8> %passthru) {
; RV32-LABEL: mgather_v2i8_sextload_v2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e8, mf8, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; RV32-NEXT:    vsext.vf2 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2i8_sextload_v2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e8, mf8, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; RV64-NEXT:    vsext.vf2 v8, v9
; RV64-NEXT:    ret
  %v = call <2 x i8> @llvm.masked.gather.v2i8.v2p0i8(<2 x i8*> %ptrs, i32 1, <2 x i1> %m, <2 x i8> %passthru)
  %ev = sext <2 x i8> %v to <2 x i16>
  ret <2 x i16> %ev
}

define <2 x i16> @mgather_v2i8_zextload_v2i16(<2 x i8*> %ptrs, <2 x i1> %m, <2 x i8> %passthru) {
; RV32-LABEL: mgather_v2i8_zextload_v2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e8, mf8, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; RV32-NEXT:    vzext.vf2 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2i8_zextload_v2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e8, mf8, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; RV64-NEXT:    vzext.vf2 v8, v9
; RV64-NEXT:    ret
  %v = call <2 x i8> @llvm.masked.gather.v2i8.v2p0i8(<2 x i8*> %ptrs, i32 1, <2 x i1> %m, <2 x i8> %passthru)
  %ev = zext <2 x i8> %v to <2 x i16>
  ret <2 x i16> %ev
}

define <2 x i32> @mgather_v2i8_sextload_v2i32(<2 x i8*> %ptrs, <2 x i1> %m, <2 x i8> %passthru) {
; RV32-LABEL: mgather_v2i8_sextload_v2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e8, mf8, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; RV32-NEXT:    vsext.vf4 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2i8_sextload_v2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e8, mf8, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; RV64-NEXT:    vsext.vf4 v8, v9
; RV64-NEXT:    ret
  %v = call <2 x i8> @llvm.masked.gather.v2i8.v2p0i8(<2 x i8*> %ptrs, i32 1, <2 x i1> %m, <2 x i8> %passthru)
  %ev = sext <2 x i8> %v to <2 x i32>
  ret <2 x i32> %ev
}

define <2 x i32> @mgather_v2i8_zextload_v2i32(<2 x i8*> %ptrs, <2 x i1> %m, <2 x i8> %passthru) {
; RV32-LABEL: mgather_v2i8_zextload_v2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e8, mf8, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; RV32-NEXT:    vzext.vf4 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2i8_zextload_v2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e8, mf8, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; RV64-NEXT:    vzext.vf4 v8, v9
; RV64-NEXT:    ret
  %v = call <2 x i8> @llvm.masked.gather.v2i8.v2p0i8(<2 x i8*> %ptrs, i32 1, <2 x i1> %m, <2 x i8> %passthru)
  %ev = zext <2 x i8> %v to <2 x i32>
  ret <2 x i32> %ev
}

define <2 x i64> @mgather_v2i8_sextload_v2i64(<2 x i8*> %ptrs, <2 x i1> %m, <2 x i8> %passthru) {
; RV32-LABEL: mgather_v2i8_sextload_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e8, mf8, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; RV32-NEXT:    vsext.vf8 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2i8_sextload_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e8, mf8, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; RV64-NEXT:    vsext.vf8 v8, v9
; RV64-NEXT:    ret
  %v = call <2 x i8> @llvm.masked.gather.v2i8.v2p0i8(<2 x i8*> %ptrs, i32 1, <2 x i1> %m, <2 x i8> %passthru)
  %ev = sext <2 x i8> %v to <2 x i64>
  ret <2 x i64> %ev
}

define <2 x i64> @mgather_v2i8_zextload_v2i64(<2 x i8*> %ptrs, <2 x i1> %m, <2 x i8> %passthru) {
; RV32-LABEL: mgather_v2i8_zextload_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e8, mf8, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; RV32-NEXT:    vzext.vf8 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2i8_zextload_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e8, mf8, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; RV64-NEXT:    vzext.vf8 v8, v9
; RV64-NEXT:    ret
  %v = call <2 x i8> @llvm.masked.gather.v2i8.v2p0i8(<2 x i8*> %ptrs, i32 1, <2 x i1> %m, <2 x i8> %passthru)
  %ev = zext <2 x i8> %v to <2 x i64>
  ret <2 x i64> %ev
}

declare <4 x i8> @llvm.masked.gather.v4i8.v4p0i8(<4 x i8*>, i32, <4 x i1>, <4 x i8>)

define <4 x i8> @mgather_v4i8(<4 x i8*> %ptrs, <4 x i1> %m, <4 x i8> %passthru) {
; RV32-LABEL: mgather_v4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e8, mf4, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e8, mf4, tu, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v10
; RV64-NEXT:    ret
  %v = call <4 x i8> @llvm.masked.gather.v4i8.v4p0i8(<4 x i8*> %ptrs, i32 1, <4 x i1> %m, <4 x i8> %passthru)
  ret <4 x i8> %v
}

define <4 x i8> @mgather_truemask_v4i8(<4 x i8*> %ptrs, <4 x i8> %passthru) {
; RV32-LABEL: mgather_truemask_v4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e8, mf4, ta, mu
; RV32-NEXT:    vluxei32.v v25, (zero), v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_truemask_v4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e8, mf4, ta, mu
; RV64-NEXT:    vluxei64.v v25, (zero), v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> undef, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> undef, <4 x i32> zeroinitializer
  %v = call <4 x i8> @llvm.masked.gather.v4i8.v4p0i8(<4 x i8*> %ptrs, i32 1, <4 x i1> %mtrue, <4 x i8> %passthru)
  ret <4 x i8> %v
}

define <4 x i8> @mgather_falsemask_v4i8(<4 x i8*> %ptrs, <4 x i8> %passthru) {
; RV32-LABEL: mgather_falsemask_v4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_falsemask_v4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vmv1r.v v8, v10
; RV64-NEXT:    ret
  %v = call <4 x i8> @llvm.masked.gather.v4i8.v4p0i8(<4 x i8*> %ptrs, i32 1, <4 x i1> zeroinitializer, <4 x i8> %passthru)
  ret <4 x i8> %v
}

declare <8 x i8> @llvm.masked.gather.v8i8.v8p0i8(<8 x i8*>, i32, <8 x i1>, <8 x i8>)

define <8 x i8> @mgather_v8i8(<8 x i8*> %ptrs, <8 x i1> %m, <8 x i8> %passthru) {
; RV32-LABEL: mgather_v8i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e8, mf2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v8i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e8, mf2, tu, mu
; RV64-NEXT:    vluxei64.v v12, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v12
; RV64-NEXT:    ret
  %v = call <8 x i8> @llvm.masked.gather.v8i8.v8p0i8(<8 x i8*> %ptrs, i32 1, <8 x i1> %m, <8 x i8> %passthru)
  ret <8 x i8> %v
}

define <8 x i8> @mgather_baseidx_v8i8(i8* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x i8> %passthru) {
; RV32-LABEL: mgather_baseidx_v8i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v26, v8
; RV32-NEXT:    vsetvli zero, zero, e8, mf2, tu, mu
; RV32-NEXT:    vluxei32.v v9, (a0), v26, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v28, v8
; RV64-NEXT:    vsetvli zero, zero, e8, mf2, tu, mu
; RV64-NEXT:    vluxei64.v v9, (a0), v28, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i8, i8* %base, <8 x i8> %idxs
  %v = call <8 x i8> @llvm.masked.gather.v8i8.v8p0i8(<8 x i8*> %ptrs, i32 1, <8 x i1> %m, <8 x i8> %passthru)
  ret <8 x i8> %v
}

declare <1 x i16> @llvm.masked.gather.v1i16.v1p0i16(<1 x i16*>, i32, <1 x i1>, <1 x i16>)

define <1 x i16> @mgather_v1i16(<1 x i16*> %ptrs, <1 x i1> %m, <1 x i16> %passthru) {
; RV32-LABEL: mgather_v1i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e16, mf4, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v1i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e16, mf4, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <1 x i16> @llvm.masked.gather.v1i16.v1p0i16(<1 x i16*> %ptrs, i32 2, <1 x i1> %m, <1 x i16> %passthru)
  ret <1 x i16> %v
}

declare <2 x i16> @llvm.masked.gather.v2i16.v2p0i16(<2 x i16*>, i32, <2 x i1>, <2 x i16>)

define <2 x i16> @mgather_v2i16(<2 x i16*> %ptrs, <2 x i1> %m, <2 x i16> %passthru) {
; RV32-LABEL: mgather_v2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e16, mf4, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e16, mf4, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <2 x i16> @llvm.masked.gather.v2i16.v2p0i16(<2 x i16*> %ptrs, i32 2, <2 x i1> %m, <2 x i16> %passthru)
  ret <2 x i16> %v
}

define <2 x i32> @mgather_v2i16_sextload_v2i32(<2 x i16*> %ptrs, <2 x i1> %m, <2 x i16> %passthru) {
; RV32-LABEL: mgather_v2i16_sextload_v2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e16, mf4, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; RV32-NEXT:    vsext.vf2 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2i16_sextload_v2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e16, mf4, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; RV64-NEXT:    vsext.vf2 v8, v9
; RV64-NEXT:    ret
  %v = call <2 x i16> @llvm.masked.gather.v2i16.v2p0i16(<2 x i16*> %ptrs, i32 2, <2 x i1> %m, <2 x i16> %passthru)
  %ev = sext <2 x i16> %v to <2 x i32>
  ret <2 x i32> %ev
}

define <2 x i32> @mgather_v2i16_zextload_v2i32(<2 x i16*> %ptrs, <2 x i1> %m, <2 x i16> %passthru) {
; RV32-LABEL: mgather_v2i16_zextload_v2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e16, mf4, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; RV32-NEXT:    vzext.vf2 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2i16_zextload_v2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e16, mf4, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; RV64-NEXT:    vzext.vf2 v8, v9
; RV64-NEXT:    ret
  %v = call <2 x i16> @llvm.masked.gather.v2i16.v2p0i16(<2 x i16*> %ptrs, i32 2, <2 x i1> %m, <2 x i16> %passthru)
  %ev = zext <2 x i16> %v to <2 x i32>
  ret <2 x i32> %ev
}

define <2 x i64> @mgather_v2i16_sextload_v2i64(<2 x i16*> %ptrs, <2 x i1> %m, <2 x i16> %passthru) {
; RV32-LABEL: mgather_v2i16_sextload_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e16, mf4, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; RV32-NEXT:    vsext.vf4 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2i16_sextload_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e16, mf4, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; RV64-NEXT:    vsext.vf4 v8, v9
; RV64-NEXT:    ret
  %v = call <2 x i16> @llvm.masked.gather.v2i16.v2p0i16(<2 x i16*> %ptrs, i32 2, <2 x i1> %m, <2 x i16> %passthru)
  %ev = sext <2 x i16> %v to <2 x i64>
  ret <2 x i64> %ev
}

define <2 x i64> @mgather_v2i16_zextload_v2i64(<2 x i16*> %ptrs, <2 x i1> %m, <2 x i16> %passthru) {
; RV32-LABEL: mgather_v2i16_zextload_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e16, mf4, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; RV32-NEXT:    vzext.vf4 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2i16_zextload_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e16, mf4, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; RV64-NEXT:    vzext.vf4 v8, v9
; RV64-NEXT:    ret
  %v = call <2 x i16> @llvm.masked.gather.v2i16.v2p0i16(<2 x i16*> %ptrs, i32 2, <2 x i1> %m, <2 x i16> %passthru)
  %ev = zext <2 x i16> %v to <2 x i64>
  ret <2 x i64> %ev
}

declare <4 x i16> @llvm.masked.gather.v4i16.v4p0i16(<4 x i16*>, i32, <4 x i1>, <4 x i16>)

define <4 x i16> @mgather_v4i16(<4 x i16*> %ptrs, <4 x i1> %m, <4 x i16> %passthru) {
; RV32-LABEL: mgather_v4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e16, mf2, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e16, mf2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v10
; RV64-NEXT:    ret
  %v = call <4 x i16> @llvm.masked.gather.v4i16.v4p0i16(<4 x i16*> %ptrs, i32 2, <4 x i1> %m, <4 x i16> %passthru)
  ret <4 x i16> %v
}

define <4 x i16> @mgather_truemask_v4i16(<4 x i16*> %ptrs, <4 x i16> %passthru) {
; RV32-LABEL: mgather_truemask_v4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; RV32-NEXT:    vluxei32.v v25, (zero), v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_truemask_v4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; RV64-NEXT:    vluxei64.v v25, (zero), v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> undef, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> undef, <4 x i32> zeroinitializer
  %v = call <4 x i16> @llvm.masked.gather.v4i16.v4p0i16(<4 x i16*> %ptrs, i32 2, <4 x i1> %mtrue, <4 x i16> %passthru)
  ret <4 x i16> %v
}

define <4 x i16> @mgather_falsemask_v4i16(<4 x i16*> %ptrs, <4 x i16> %passthru) {
; RV32-LABEL: mgather_falsemask_v4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_falsemask_v4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vmv1r.v v8, v10
; RV64-NEXT:    ret
  %v = call <4 x i16> @llvm.masked.gather.v4i16.v4p0i16(<4 x i16*> %ptrs, i32 2, <4 x i1> zeroinitializer, <4 x i16> %passthru)
  ret <4 x i16> %v
}

declare <8 x i16> @llvm.masked.gather.v8i16.v8p0i16(<8 x i16*>, i32, <8 x i1>, <8 x i16>)

define <8 x i16> @mgather_v8i16(<8 x i16*> %ptrs, <8 x i1> %m, <8 x i16> %passthru) {
; RV32-LABEL: mgather_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e16, m1, tu, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e16, m1, tu, mu
; RV64-NEXT:    vluxei64.v v12, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v12
; RV64-NEXT:    ret
  %v = call <8 x i16> @llvm.masked.gather.v8i16.v8p0i16(<8 x i16*> %ptrs, i32 2, <8 x i1> %m, <8 x i16> %passthru)
  ret <8 x i16> %v
}

define <8 x i16> @mgather_baseidx_v8i8_v8i16(i16* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x i16> %passthru) {
; RV32-LABEL: mgather_baseidx_v8i8_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v26, v8
; RV32-NEXT:    vadd.vv v26, v26, v26
; RV32-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; RV32-NEXT:    vluxei32.v v9, (a0), v26, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8i8_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v28, v8
; RV64-NEXT:    vadd.vv v28, v28, v28
; RV64-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; RV64-NEXT:    vluxei64.v v9, (a0), v28, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i16, i16* %base, <8 x i8> %idxs
  %v = call <8 x i16> @llvm.masked.gather.v8i16.v8p0i16(<8 x i16*> %ptrs, i32 2, <8 x i1> %m, <8 x i16> %passthru)
  ret <8 x i16> %v
}

define <8 x i16> @mgather_baseidx_sext_v8i8_v8i16(i16* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x i16> %passthru) {
; RV32-LABEL: mgather_baseidx_sext_v8i8_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v26, v8
; RV32-NEXT:    vadd.vv v26, v26, v26
; RV32-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; RV32-NEXT:    vluxei32.v v9, (a0), v26, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_sext_v8i8_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v28, v8
; RV64-NEXT:    vadd.vv v28, v28, v28
; RV64-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; RV64-NEXT:    vluxei64.v v9, (a0), v28, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i16>
  %ptrs = getelementptr inbounds i16, i16* %base, <8 x i16> %eidxs
  %v = call <8 x i16> @llvm.masked.gather.v8i16.v8p0i16(<8 x i16*> %ptrs, i32 2, <8 x i1> %m, <8 x i16> %passthru)
  ret <8 x i16> %v
}

define <8 x i16> @mgather_baseidx_zext_v8i8_v8i16(i16* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x i16> %passthru) {
; RV32-LABEL: mgather_baseidx_zext_v8i8_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vzext.vf4 v26, v8
; RV32-NEXT:    vadd.vv v26, v26, v26
; RV32-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; RV32-NEXT:    vluxei32.v v9, (a0), v26, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_zext_v8i8_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf8 v28, v8
; RV64-NEXT:    vadd.vv v28, v28, v28
; RV64-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; RV64-NEXT:    vluxei64.v v9, (a0), v28, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i16>
  %ptrs = getelementptr inbounds i16, i16* %base, <8 x i16> %eidxs
  %v = call <8 x i16> @llvm.masked.gather.v8i16.v8p0i16(<8 x i16*> %ptrs, i32 2, <8 x i1> %m, <8 x i16> %passthru)
  ret <8 x i16> %v
}

define <8 x i16> @mgather_baseidx_v8i16(i16* %base, <8 x i16> %idxs, <8 x i1> %m, <8 x i16> %passthru) {
; RV32-LABEL: mgather_baseidx_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf2 v26, v8
; RV32-NEXT:    vadd.vv v26, v26, v26
; RV32-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; RV32-NEXT:    vluxei32.v v9, (a0), v26, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v28, v8
; RV64-NEXT:    vadd.vv v28, v28, v28
; RV64-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; RV64-NEXT:    vluxei64.v v9, (a0), v28, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i16, i16* %base, <8 x i16> %idxs
  %v = call <8 x i16> @llvm.masked.gather.v8i16.v8p0i16(<8 x i16*> %ptrs, i32 2, <8 x i1> %m, <8 x i16> %passthru)
  ret <8 x i16> %v
}

declare <1 x i32> @llvm.masked.gather.v1i32.v1p0i32(<1 x i32*>, i32, <1 x i1>, <1 x i32>)

define <1 x i32> @mgather_v1i32(<1 x i32*> %ptrs, <1 x i1> %m, <1 x i32> %passthru) {
; RV32-LABEL: mgather_v1i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e32, mf2, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v1i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e32, mf2, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <1 x i32> @llvm.masked.gather.v1i32.v1p0i32(<1 x i32*> %ptrs, i32 4, <1 x i1> %m, <1 x i32> %passthru)
  ret <1 x i32> %v
}

declare <2 x i32> @llvm.masked.gather.v2i32.v2p0i32(<2 x i32*>, i32, <2 x i1>, <2 x i32>)

define <2 x i32> @mgather_v2i32(<2 x i32*> %ptrs, <2 x i1> %m, <2 x i32> %passthru) {
; RV32-LABEL: mgather_v2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e32, mf2, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e32, mf2, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <2 x i32> @llvm.masked.gather.v2i32.v2p0i32(<2 x i32*> %ptrs, i32 4, <2 x i1> %m, <2 x i32> %passthru)
  ret <2 x i32> %v
}

define <2 x i64> @mgather_v2i32_sextload_v2i64(<2 x i32*> %ptrs, <2 x i1> %m, <2 x i32> %passthru) {
; RV32-LABEL: mgather_v2i32_sextload_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e32, mf2, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; RV32-NEXT:    vsext.vf2 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2i32_sextload_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e32, mf2, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; RV64-NEXT:    vsext.vf2 v8, v9
; RV64-NEXT:    ret
  %v = call <2 x i32> @llvm.masked.gather.v2i32.v2p0i32(<2 x i32*> %ptrs, i32 4, <2 x i1> %m, <2 x i32> %passthru)
  %ev = sext <2 x i32> %v to <2 x i64>
  ret <2 x i64> %ev
}

define <2 x i64> @mgather_v2i32_zextload_v2i64(<2 x i32*> %ptrs, <2 x i1> %m, <2 x i32> %passthru) {
; RV32-LABEL: mgather_v2i32_zextload_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e32, mf2, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; RV32-NEXT:    vzext.vf2 v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2i32_zextload_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e32, mf2, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; RV64-NEXT:    vzext.vf2 v8, v9
; RV64-NEXT:    ret
  %v = call <2 x i32> @llvm.masked.gather.v2i32.v2p0i32(<2 x i32*> %ptrs, i32 4, <2 x i1> %m, <2 x i32> %passthru)
  %ev = zext <2 x i32> %v to <2 x i64>
  ret <2 x i64> %ev
}

declare <4 x i32> @llvm.masked.gather.v4i32.v4p0i32(<4 x i32*>, i32, <4 x i1>, <4 x i32>)

define <4 x i32> @mgather_v4i32(<4 x i32*> %ptrs, <4 x i1> %m, <4 x i32> %passthru) {
; RV32-LABEL: mgather_v4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e32, m1, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e32, m1, tu, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v10
; RV64-NEXT:    ret
  %v = call <4 x i32> @llvm.masked.gather.v4i32.v4p0i32(<4 x i32*> %ptrs, i32 4, <4 x i1> %m, <4 x i32> %passthru)
  ret <4 x i32> %v
}

define <4 x i32> @mgather_truemask_v4i32(<4 x i32*> %ptrs, <4 x i32> %passthru) {
; RV32-LABEL: mgather_truemask_v4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; RV32-NEXT:    vluxei32.v v8, (zero), v8
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_truemask_v4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; RV64-NEXT:    vluxei64.v v25, (zero), v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> undef, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> undef, <4 x i32> zeroinitializer
  %v = call <4 x i32> @llvm.masked.gather.v4i32.v4p0i32(<4 x i32*> %ptrs, i32 4, <4 x i1> %mtrue, <4 x i32> %passthru)
  ret <4 x i32> %v
}

define <4 x i32> @mgather_falsemask_v4i32(<4 x i32*> %ptrs, <4 x i32> %passthru) {
; RV32-LABEL: mgather_falsemask_v4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_falsemask_v4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vmv1r.v v8, v10
; RV64-NEXT:    ret
  %v = call <4 x i32> @llvm.masked.gather.v4i32.v4p0i32(<4 x i32*> %ptrs, i32 4, <4 x i1> zeroinitializer, <4 x i32> %passthru)
  ret <4 x i32> %v
}

declare <8 x i32> @llvm.masked.gather.v8i32.v8p0i32(<8 x i32*>, i32, <8 x i1>, <8 x i32>)

define <8 x i32> @mgather_v8i32(<8 x i32*> %ptrs, <8 x i1> %m, <8 x i32> %passthru) {
; RV32-LABEL: mgather_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e32, m2, tu, mu
; RV64-NEXT:    vluxei64.v v12, (zero), v8, v0.t
; RV64-NEXT:    vmv2r.v v8, v12
; RV64-NEXT:    ret
  %v = call <8 x i32> @llvm.masked.gather.v8i32.v8p0i32(<8 x i32*> %ptrs, i32 4, <8 x i1> %m, <8 x i32> %passthru)
  ret <8 x i32> %v
}

define <8 x i32> @mgather_baseidx_v8i8_v8i32(i32* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x i32> %passthru) {
; RV32-LABEL: mgather_baseidx_v8i8_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v26, v8
; RV32-NEXT:    vsll.vi v26, v26, 2
; RV32-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (a0), v26, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8i8_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (a0), v28, v0.t
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i32, i32* %base, <8 x i8> %idxs
  %v = call <8 x i32> @llvm.masked.gather.v8i32.v8p0i32(<8 x i32*> %ptrs, i32 4, <8 x i1> %m, <8 x i32> %passthru)
  ret <8 x i32> %v
}

define <8 x i32> @mgather_baseidx_sext_v8i8_v8i32(i32* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x i32> %passthru) {
; RV32-LABEL: mgather_baseidx_sext_v8i8_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v26, v8
; RV32-NEXT:    vsll.vi v26, v26, 2
; RV32-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (a0), v26, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_sext_v8i8_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (a0), v28, v0.t
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds i32, i32* %base, <8 x i32> %eidxs
  %v = call <8 x i32> @llvm.masked.gather.v8i32.v8p0i32(<8 x i32*> %ptrs, i32 4, <8 x i1> %m, <8 x i32> %passthru)
  ret <8 x i32> %v
}

define <8 x i32> @mgather_baseidx_zext_v8i8_v8i32(i32* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x i32> %passthru) {
; RV32-LABEL: mgather_baseidx_zext_v8i8_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vzext.vf4 v26, v8
; RV32-NEXT:    vsll.vi v26, v26, 2
; RV32-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (a0), v26, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_zext_v8i8_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf8 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (a0), v28, v0.t
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds i32, i32* %base, <8 x i32> %eidxs
  %v = call <8 x i32> @llvm.masked.gather.v8i32.v8p0i32(<8 x i32*> %ptrs, i32 4, <8 x i1> %m, <8 x i32> %passthru)
  ret <8 x i32> %v
}

define <8 x i32> @mgather_baseidx_v8i16_v8i32(i32* %base, <8 x i16> %idxs, <8 x i1> %m, <8 x i32> %passthru) {
; RV32-LABEL: mgather_baseidx_v8i16_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf2 v26, v8
; RV32-NEXT:    vsll.vi v26, v26, 2
; RV32-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (a0), v26, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8i16_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (a0), v28, v0.t
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i32, i32* %base, <8 x i16> %idxs
  %v = call <8 x i32> @llvm.masked.gather.v8i32.v8p0i32(<8 x i32*> %ptrs, i32 4, <8 x i1> %m, <8 x i32> %passthru)
  ret <8 x i32> %v
}

define <8 x i32> @mgather_baseidx_sext_v8i16_v8i32(i32* %base, <8 x i16> %idxs, <8 x i1> %m, <8 x i32> %passthru) {
; RV32-LABEL: mgather_baseidx_sext_v8i16_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf2 v26, v8
; RV32-NEXT:    vsll.vi v26, v26, 2
; RV32-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (a0), v26, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_sext_v8i16_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (a0), v28, v0.t
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %eidxs = sext <8 x i16> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds i32, i32* %base, <8 x i32> %eidxs
  %v = call <8 x i32> @llvm.masked.gather.v8i32.v8p0i32(<8 x i32*> %ptrs, i32 4, <8 x i1> %m, <8 x i32> %passthru)
  ret <8 x i32> %v
}

define <8 x i32> @mgather_baseidx_zext_v8i16_v8i32(i32* %base, <8 x i16> %idxs, <8 x i1> %m, <8 x i32> %passthru) {
; RV32-LABEL: mgather_baseidx_zext_v8i16_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vzext.vf2 v26, v8
; RV32-NEXT:    vsll.vi v26, v26, 2
; RV32-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (a0), v26, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_zext_v8i16_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf4 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (a0), v28, v0.t
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %eidxs = zext <8 x i16> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds i32, i32* %base, <8 x i32> %eidxs
  %v = call <8 x i32> @llvm.masked.gather.v8i32.v8p0i32(<8 x i32*> %ptrs, i32 4, <8 x i1> %m, <8 x i32> %passthru)
  ret <8 x i32> %v
}

define <8 x i32> @mgather_baseidx_v8i32(i32* %base, <8 x i32> %idxs, <8 x i1> %m, <8 x i32> %passthru) {
; RV32-LABEL: mgather_baseidx_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsll.vi v26, v8, 2
; RV32-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (a0), v26, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf2 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (a0), v28, v0.t
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i32, i32* %base, <8 x i32> %idxs
  %v = call <8 x i32> @llvm.masked.gather.v8i32.v8p0i32(<8 x i32*> %ptrs, i32 4, <8 x i1> %m, <8 x i32> %passthru)
  ret <8 x i32> %v
}

declare <1 x i64> @llvm.masked.gather.v1i64.v1p0i64(<1 x i64*>, i32, <1 x i1>, <1 x i64>)

define <1 x i64> @mgather_v1i64(<1 x i64*> %ptrs, <1 x i1> %m, <1 x i64> %passthru) {
; RV32-LABEL: mgather_v1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e64, m1, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e64, m1, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <1 x i64> @llvm.masked.gather.v1i64.v1p0i64(<1 x i64*> %ptrs, i32 8, <1 x i1> %m, <1 x i64> %passthru)
  ret <1 x i64> %v
}

declare <2 x i64> @llvm.masked.gather.v2i64.v2p0i64(<2 x i64*>, i32, <2 x i1>, <2 x i64>)

define <2 x i64> @mgather_v2i64(<2 x i64*> %ptrs, <2 x i1> %m, <2 x i64> %passthru) {
; RV32-LABEL: mgather_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e64, m1, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e64, m1, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <2 x i64> @llvm.masked.gather.v2i64.v2p0i64(<2 x i64*> %ptrs, i32 8, <2 x i1> %m, <2 x i64> %passthru)
  ret <2 x i64> %v
}

declare <4 x i64> @llvm.masked.gather.v4i64.v4p0i64(<4 x i64*>, i32, <4 x i1>, <4 x i64>)

define <4 x i64> @mgather_v4i64(<4 x i64*> %ptrs, <4 x i1> %m, <4 x i64> %passthru) {
; RV32-LABEL: mgather_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e64, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e64, m2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %v = call <4 x i64> @llvm.masked.gather.v4i64.v4p0i64(<4 x i64*> %ptrs, i32 8, <4 x i1> %m, <4 x i64> %passthru)
  ret <4 x i64> %v
}

define <4 x i64> @mgather_truemask_v4i64(<4 x i64*> %ptrs, <4 x i64> %passthru) {
; RV32-LABEL: mgather_truemask_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; RV32-NEXT:    vluxei32.v v26, (zero), v8
; RV32-NEXT:    vmv2r.v v8, v26
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_truemask_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; RV64-NEXT:    vluxei64.v v8, (zero), v8
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> undef, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> undef, <4 x i32> zeroinitializer
  %v = call <4 x i64> @llvm.masked.gather.v4i64.v4p0i64(<4 x i64*> %ptrs, i32 8, <4 x i1> %mtrue, <4 x i64> %passthru)
  ret <4 x i64> %v
}

define <4 x i64> @mgather_falsemask_v4i64(<4 x i64*> %ptrs, <4 x i64> %passthru) {
; RV32-LABEL: mgather_falsemask_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_falsemask_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %v = call <4 x i64> @llvm.masked.gather.v4i64.v4p0i64(<4 x i64*> %ptrs, i32 8, <4 x i1> zeroinitializer, <4 x i64> %passthru)
  ret <4 x i64> %v
}

declare <8 x i64> @llvm.masked.gather.v8i64.v8p0i64(<8 x i64*>, i32, <8 x i1>, <8 x i64>)

define <8 x i64> @mgather_v8i64(<8 x i64*> %ptrs, <8 x i1> %m, <8 x i64> %passthru) {
; RV32-LABEL: mgather_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, tu, mu
; RV32-NEXT:    vluxei32.v v12, (zero), v8, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (zero), v8, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %v = call <8 x i64> @llvm.masked.gather.v8i64.v8p0i64(<8 x i64*> %ptrs, i32 8, <8 x i1> %m, <8 x i64> %passthru)
  ret <8 x i64> %v
}

define <8 x i64> @mgather_baseidx_v8i8_v8i64(i64* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x i64> %passthru) {
; RV32-LABEL: mgather_baseidx_v8i8_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v26, v8
; RV32-NEXT:    vsll.vi v26, v26, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei32.v v12, (a0), v26, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8i8_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i8> %idxs
  %v = call <8 x i64> @llvm.masked.gather.v8i64.v8p0i64(<8 x i64*> %ptrs, i32 8, <8 x i1> %m, <8 x i64> %passthru)
  ret <8 x i64> %v
}

define <8 x i64> @mgather_baseidx_sext_v8i8_v8i64(i64* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x i64> %passthru) {
; RV32-LABEL: mgather_baseidx_sext_v8i8_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsext.vf8 v28, v8
; RV32-NEXT:    vsll.vi v28, v28, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_sext_v8i8_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i64> %eidxs
  %v = call <8 x i64> @llvm.masked.gather.v8i64.v8p0i64(<8 x i64*> %ptrs, i32 8, <8 x i1> %m, <8 x i64> %passthru)
  ret <8 x i64> %v
}

define <8 x i64> @mgather_baseidx_zext_v8i8_v8i64(i64* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x i64> %passthru) {
; RV32-LABEL: mgather_baseidx_zext_v8i8_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vzext.vf8 v28, v8
; RV32-NEXT:    vsll.vi v28, v28, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_zext_v8i8_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf8 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i64> %eidxs
  %v = call <8 x i64> @llvm.masked.gather.v8i64.v8p0i64(<8 x i64*> %ptrs, i32 8, <8 x i1> %m, <8 x i64> %passthru)
  ret <8 x i64> %v
}

define <8 x i64> @mgather_baseidx_v8i16_v8i64(i64* %base, <8 x i16> %idxs, <8 x i1> %m, <8 x i64> %passthru) {
; RV32-LABEL: mgather_baseidx_v8i16_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf2 v26, v8
; RV32-NEXT:    vsll.vi v26, v26, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei32.v v12, (a0), v26, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8i16_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i16> %idxs
  %v = call <8 x i64> @llvm.masked.gather.v8i64.v8p0i64(<8 x i64*> %ptrs, i32 8, <8 x i1> %m, <8 x i64> %passthru)
  ret <8 x i64> %v
}

define <8 x i64> @mgather_baseidx_sext_v8i16_v8i64(i64* %base, <8 x i16> %idxs, <8 x i1> %m, <8 x i64> %passthru) {
; RV32-LABEL: mgather_baseidx_sext_v8i16_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v28, v8
; RV32-NEXT:    vsll.vi v28, v28, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_sext_v8i16_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %eidxs = sext <8 x i16> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i64> %eidxs
  %v = call <8 x i64> @llvm.masked.gather.v8i64.v8p0i64(<8 x i64*> %ptrs, i32 8, <8 x i1> %m, <8 x i64> %passthru)
  ret <8 x i64> %v
}

define <8 x i64> @mgather_baseidx_zext_v8i16_v8i64(i64* %base, <8 x i16> %idxs, <8 x i1> %m, <8 x i64> %passthru) {
; RV32-LABEL: mgather_baseidx_zext_v8i16_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vzext.vf4 v28, v8
; RV32-NEXT:    vsll.vi v28, v28, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_zext_v8i16_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf4 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %eidxs = zext <8 x i16> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i64> %eidxs
  %v = call <8 x i64> @llvm.masked.gather.v8i64.v8p0i64(<8 x i64*> %ptrs, i32 8, <8 x i1> %m, <8 x i64> %passthru)
  ret <8 x i64> %v
}

define <8 x i64> @mgather_baseidx_v8i32_v8i64(i64* %base, <8 x i32> %idxs, <8 x i1> %m, <8 x i64> %passthru) {
; RV32-LABEL: mgather_baseidx_v8i32_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsll.vi v26, v8, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei32.v v12, (a0), v26, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8i32_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf2 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i32> %idxs
  %v = call <8 x i64> @llvm.masked.gather.v8i64.v8p0i64(<8 x i64*> %ptrs, i32 8, <8 x i1> %m, <8 x i64> %passthru)
  ret <8 x i64> %v
}

define <8 x i64> @mgather_baseidx_sext_v8i32_v8i64(i64* %base, <8 x i32> %idxs, <8 x i1> %m, <8 x i64> %passthru) {
; RV32-LABEL: mgather_baseidx_sext_v8i32_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v28, v8
; RV32-NEXT:    vsll.vi v28, v28, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_sext_v8i32_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf2 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %eidxs = sext <8 x i32> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i64> %eidxs
  %v = call <8 x i64> @llvm.masked.gather.v8i64.v8p0i64(<8 x i64*> %ptrs, i32 8, <8 x i1> %m, <8 x i64> %passthru)
  ret <8 x i64> %v
}

define <8 x i64> @mgather_baseidx_zext_v8i32_v8i64(i64* %base, <8 x i32> %idxs, <8 x i1> %m, <8 x i64> %passthru) {
; RV32-LABEL: mgather_baseidx_zext_v8i32_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vzext.vf2 v28, v8
; RV32-NEXT:    vsll.vi v28, v28, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_zext_v8i32_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf2 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %eidxs = zext <8 x i32> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i64> %eidxs
  %v = call <8 x i64> @llvm.masked.gather.v8i64.v8p0i64(<8 x i64*> %ptrs, i32 8, <8 x i1> %m, <8 x i64> %passthru)
  ret <8 x i64> %v
}

define <8 x i64> @mgather_baseidx_v8i64(i64* %base, <8 x i64> %idxs, <8 x i1> %m, <8 x i64> %passthru) {
; RV32-LABEL: mgather_baseidx_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsll.vi v28, v8, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsll.vi v28, v8, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i64> %idxs
  %v = call <8 x i64> @llvm.masked.gather.v8i64.v8p0i64(<8 x i64*> %ptrs, i32 8, <8 x i1> %m, <8 x i64> %passthru)
  ret <8 x i64> %v
}

declare <1 x half> @llvm.masked.gather.v1f16.v1p0f16(<1 x half*>, i32, <1 x i1>, <1 x half>)

define <1 x half> @mgather_v1f16(<1 x half*> %ptrs, <1 x i1> %m, <1 x half> %passthru) {
; RV32-LABEL: mgather_v1f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e16, mf4, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v1f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e16, mf4, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <1 x half> @llvm.masked.gather.v1f16.v1p0f16(<1 x half*> %ptrs, i32 2, <1 x i1> %m, <1 x half> %passthru)
  ret <1 x half> %v
}

declare <2 x half> @llvm.masked.gather.v2f16.v2p0f16(<2 x half*>, i32, <2 x i1>, <2 x half>)

define <2 x half> @mgather_v2f16(<2 x half*> %ptrs, <2 x i1> %m, <2 x half> %passthru) {
; RV32-LABEL: mgather_v2f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e16, mf4, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e16, mf4, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <2 x half> @llvm.masked.gather.v2f16.v2p0f16(<2 x half*> %ptrs, i32 2, <2 x i1> %m, <2 x half> %passthru)
  ret <2 x half> %v
}

declare <4 x half> @llvm.masked.gather.v4f16.v4p0f16(<4 x half*>, i32, <4 x i1>, <4 x half>)

define <4 x half> @mgather_v4f16(<4 x half*> %ptrs, <4 x i1> %m, <4 x half> %passthru) {
; RV32-LABEL: mgather_v4f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e16, mf2, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v4f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e16, mf2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v10
; RV64-NEXT:    ret
  %v = call <4 x half> @llvm.masked.gather.v4f16.v4p0f16(<4 x half*> %ptrs, i32 2, <4 x i1> %m, <4 x half> %passthru)
  ret <4 x half> %v
}

define <4 x half> @mgather_truemask_v4f16(<4 x half*> %ptrs, <4 x half> %passthru) {
; RV32-LABEL: mgather_truemask_v4f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; RV32-NEXT:    vluxei32.v v25, (zero), v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_truemask_v4f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; RV64-NEXT:    vluxei64.v v25, (zero), v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> undef, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> undef, <4 x i32> zeroinitializer
  %v = call <4 x half> @llvm.masked.gather.v4f16.v4p0f16(<4 x half*> %ptrs, i32 2, <4 x i1> %mtrue, <4 x half> %passthru)
  ret <4 x half> %v
}

define <4 x half> @mgather_falsemask_v4f16(<4 x half*> %ptrs, <4 x half> %passthru) {
; RV32-LABEL: mgather_falsemask_v4f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_falsemask_v4f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vmv1r.v v8, v10
; RV64-NEXT:    ret
  %v = call <4 x half> @llvm.masked.gather.v4f16.v4p0f16(<4 x half*> %ptrs, i32 2, <4 x i1> zeroinitializer, <4 x half> %passthru)
  ret <4 x half> %v
}

declare <8 x half> @llvm.masked.gather.v8f16.v8p0f16(<8 x half*>, i32, <8 x i1>, <8 x half>)

define <8 x half> @mgather_v8f16(<8 x half*> %ptrs, <8 x i1> %m, <8 x half> %passthru) {
; RV32-LABEL: mgather_v8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e16, m1, tu, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e16, m1, tu, mu
; RV64-NEXT:    vluxei64.v v12, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v12
; RV64-NEXT:    ret
  %v = call <8 x half> @llvm.masked.gather.v8f16.v8p0f16(<8 x half*> %ptrs, i32 2, <8 x i1> %m, <8 x half> %passthru)
  ret <8 x half> %v
}

define <8 x half> @mgather_baseidx_v8i8_v8f16(half* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x half> %passthru) {
; RV32-LABEL: mgather_baseidx_v8i8_v8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v26, v8
; RV32-NEXT:    vadd.vv v26, v26, v26
; RV32-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; RV32-NEXT:    vluxei32.v v9, (a0), v26, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8i8_v8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v28, v8
; RV64-NEXT:    vadd.vv v28, v28, v28
; RV64-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; RV64-NEXT:    vluxei64.v v9, (a0), v28, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds half, half* %base, <8 x i8> %idxs
  %v = call <8 x half> @llvm.masked.gather.v8f16.v8p0f16(<8 x half*> %ptrs, i32 2, <8 x i1> %m, <8 x half> %passthru)
  ret <8 x half> %v
}

define <8 x half> @mgather_baseidx_sext_v8i8_v8f16(half* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x half> %passthru) {
; RV32-LABEL: mgather_baseidx_sext_v8i8_v8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v26, v8
; RV32-NEXT:    vadd.vv v26, v26, v26
; RV32-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; RV32-NEXT:    vluxei32.v v9, (a0), v26, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_sext_v8i8_v8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v28, v8
; RV64-NEXT:    vadd.vv v28, v28, v28
; RV64-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; RV64-NEXT:    vluxei64.v v9, (a0), v28, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i16>
  %ptrs = getelementptr inbounds half, half* %base, <8 x i16> %eidxs
  %v = call <8 x half> @llvm.masked.gather.v8f16.v8p0f16(<8 x half*> %ptrs, i32 2, <8 x i1> %m, <8 x half> %passthru)
  ret <8 x half> %v
}

define <8 x half> @mgather_baseidx_zext_v8i8_v8f16(half* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x half> %passthru) {
; RV32-LABEL: mgather_baseidx_zext_v8i8_v8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vzext.vf4 v26, v8
; RV32-NEXT:    vadd.vv v26, v26, v26
; RV32-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; RV32-NEXT:    vluxei32.v v9, (a0), v26, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_zext_v8i8_v8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf8 v28, v8
; RV64-NEXT:    vadd.vv v28, v28, v28
; RV64-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; RV64-NEXT:    vluxei64.v v9, (a0), v28, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i16>
  %ptrs = getelementptr inbounds half, half* %base, <8 x i16> %eidxs
  %v = call <8 x half> @llvm.masked.gather.v8f16.v8p0f16(<8 x half*> %ptrs, i32 2, <8 x i1> %m, <8 x half> %passthru)
  ret <8 x half> %v
}

define <8 x half> @mgather_baseidx_v8f16(half* %base, <8 x i16> %idxs, <8 x i1> %m, <8 x half> %passthru) {
; RV32-LABEL: mgather_baseidx_v8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf2 v26, v8
; RV32-NEXT:    vadd.vv v26, v26, v26
; RV32-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; RV32-NEXT:    vluxei32.v v9, (a0), v26, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v28, v8
; RV64-NEXT:    vadd.vv v28, v28, v28
; RV64-NEXT:    vsetvli zero, zero, e16, m1, tu, mu
; RV64-NEXT:    vluxei64.v v9, (a0), v28, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds half, half* %base, <8 x i16> %idxs
  %v = call <8 x half> @llvm.masked.gather.v8f16.v8p0f16(<8 x half*> %ptrs, i32 2, <8 x i1> %m, <8 x half> %passthru)
  ret <8 x half> %v
}

declare <1 x float> @llvm.masked.gather.v1f32.v1p0f32(<1 x float*>, i32, <1 x i1>, <1 x float>)

define <1 x float> @mgather_v1f32(<1 x float*> %ptrs, <1 x i1> %m, <1 x float> %passthru) {
; RV32-LABEL: mgather_v1f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e32, mf2, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v1f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e32, mf2, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <1 x float> @llvm.masked.gather.v1f32.v1p0f32(<1 x float*> %ptrs, i32 4, <1 x i1> %m, <1 x float> %passthru)
  ret <1 x float> %v
}

declare <2 x float> @llvm.masked.gather.v2f32.v2p0f32(<2 x float*>, i32, <2 x i1>, <2 x float>)

define <2 x float> @mgather_v2f32(<2 x float*> %ptrs, <2 x i1> %m, <2 x float> %passthru) {
; RV32-LABEL: mgather_v2f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e32, mf2, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e32, mf2, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <2 x float> @llvm.masked.gather.v2f32.v2p0f32(<2 x float*> %ptrs, i32 4, <2 x i1> %m, <2 x float> %passthru)
  ret <2 x float> %v
}

declare <4 x float> @llvm.masked.gather.v4f32.v4p0f32(<4 x float*>, i32, <4 x i1>, <4 x float>)

define <4 x float> @mgather_v4f32(<4 x float*> %ptrs, <4 x i1> %m, <4 x float> %passthru) {
; RV32-LABEL: mgather_v4f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e32, m1, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v4f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e32, m1, tu, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v10
; RV64-NEXT:    ret
  %v = call <4 x float> @llvm.masked.gather.v4f32.v4p0f32(<4 x float*> %ptrs, i32 4, <4 x i1> %m, <4 x float> %passthru)
  ret <4 x float> %v
}

define <4 x float> @mgather_truemask_v4f32(<4 x float*> %ptrs, <4 x float> %passthru) {
; RV32-LABEL: mgather_truemask_v4f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; RV32-NEXT:    vluxei32.v v8, (zero), v8
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_truemask_v4f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; RV64-NEXT:    vluxei64.v v25, (zero), v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> undef, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> undef, <4 x i32> zeroinitializer
  %v = call <4 x float> @llvm.masked.gather.v4f32.v4p0f32(<4 x float*> %ptrs, i32 4, <4 x i1> %mtrue, <4 x float> %passthru)
  ret <4 x float> %v
}

define <4 x float> @mgather_falsemask_v4f32(<4 x float*> %ptrs, <4 x float> %passthru) {
; RV32-LABEL: mgather_falsemask_v4f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_falsemask_v4f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vmv1r.v v8, v10
; RV64-NEXT:    ret
  %v = call <4 x float> @llvm.masked.gather.v4f32.v4p0f32(<4 x float*> %ptrs, i32 4, <4 x i1> zeroinitializer, <4 x float> %passthru)
  ret <4 x float> %v
}

declare <8 x float> @llvm.masked.gather.v8f32.v8p0f32(<8 x float*>, i32, <8 x i1>, <8 x float>)

define <8 x float> @mgather_v8f32(<8 x float*> %ptrs, <8 x i1> %m, <8 x float> %passthru) {
; RV32-LABEL: mgather_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e32, m2, tu, mu
; RV64-NEXT:    vluxei64.v v12, (zero), v8, v0.t
; RV64-NEXT:    vmv2r.v v8, v12
; RV64-NEXT:    ret
  %v = call <8 x float> @llvm.masked.gather.v8f32.v8p0f32(<8 x float*> %ptrs, i32 4, <8 x i1> %m, <8 x float> %passthru)
  ret <8 x float> %v
}

define <8 x float> @mgather_baseidx_v8i8_v8f32(float* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x float> %passthru) {
; RV32-LABEL: mgather_baseidx_v8i8_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v26, v8
; RV32-NEXT:    vsll.vi v26, v26, 2
; RV32-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (a0), v26, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8i8_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (a0), v28, v0.t
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds float, float* %base, <8 x i8> %idxs
  %v = call <8 x float> @llvm.masked.gather.v8f32.v8p0f32(<8 x float*> %ptrs, i32 4, <8 x i1> %m, <8 x float> %passthru)
  ret <8 x float> %v
}

define <8 x float> @mgather_baseidx_sext_v8i8_v8f32(float* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x float> %passthru) {
; RV32-LABEL: mgather_baseidx_sext_v8i8_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v26, v8
; RV32-NEXT:    vsll.vi v26, v26, 2
; RV32-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (a0), v26, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_sext_v8i8_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (a0), v28, v0.t
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds float, float* %base, <8 x i32> %eidxs
  %v = call <8 x float> @llvm.masked.gather.v8f32.v8p0f32(<8 x float*> %ptrs, i32 4, <8 x i1> %m, <8 x float> %passthru)
  ret <8 x float> %v
}

define <8 x float> @mgather_baseidx_zext_v8i8_v8f32(float* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x float> %passthru) {
; RV32-LABEL: mgather_baseidx_zext_v8i8_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vzext.vf4 v26, v8
; RV32-NEXT:    vsll.vi v26, v26, 2
; RV32-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (a0), v26, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_zext_v8i8_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf8 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (a0), v28, v0.t
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds float, float* %base, <8 x i32> %eidxs
  %v = call <8 x float> @llvm.masked.gather.v8f32.v8p0f32(<8 x float*> %ptrs, i32 4, <8 x i1> %m, <8 x float> %passthru)
  ret <8 x float> %v
}

define <8 x float> @mgather_baseidx_v8i16_v8f32(float* %base, <8 x i16> %idxs, <8 x i1> %m, <8 x float> %passthru) {
; RV32-LABEL: mgather_baseidx_v8i16_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf2 v26, v8
; RV32-NEXT:    vsll.vi v26, v26, 2
; RV32-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (a0), v26, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8i16_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (a0), v28, v0.t
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds float, float* %base, <8 x i16> %idxs
  %v = call <8 x float> @llvm.masked.gather.v8f32.v8p0f32(<8 x float*> %ptrs, i32 4, <8 x i1> %m, <8 x float> %passthru)
  ret <8 x float> %v
}

define <8 x float> @mgather_baseidx_sext_v8i16_v8f32(float* %base, <8 x i16> %idxs, <8 x i1> %m, <8 x float> %passthru) {
; RV32-LABEL: mgather_baseidx_sext_v8i16_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf2 v26, v8
; RV32-NEXT:    vsll.vi v26, v26, 2
; RV32-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (a0), v26, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_sext_v8i16_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (a0), v28, v0.t
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %eidxs = sext <8 x i16> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds float, float* %base, <8 x i32> %eidxs
  %v = call <8 x float> @llvm.masked.gather.v8f32.v8p0f32(<8 x float*> %ptrs, i32 4, <8 x i1> %m, <8 x float> %passthru)
  ret <8 x float> %v
}

define <8 x float> @mgather_baseidx_zext_v8i16_v8f32(float* %base, <8 x i16> %idxs, <8 x i1> %m, <8 x float> %passthru) {
; RV32-LABEL: mgather_baseidx_zext_v8i16_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vzext.vf2 v26, v8
; RV32-NEXT:    vsll.vi v26, v26, 2
; RV32-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (a0), v26, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_zext_v8i16_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf4 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (a0), v28, v0.t
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %eidxs = zext <8 x i16> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds float, float* %base, <8 x i32> %eidxs
  %v = call <8 x float> @llvm.masked.gather.v8f32.v8p0f32(<8 x float*> %ptrs, i32 4, <8 x i1> %m, <8 x float> %passthru)
  ret <8 x float> %v
}

define <8 x float> @mgather_baseidx_v8f32(float* %base, <8 x i32> %idxs, <8 x i1> %m, <8 x float> %passthru) {
; RV32-LABEL: mgather_baseidx_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsll.vi v26, v8, 2
; RV32-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (a0), v26, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf2 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (a0), v28, v0.t
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds float, float* %base, <8 x i32> %idxs
  %v = call <8 x float> @llvm.masked.gather.v8f32.v8p0f32(<8 x float*> %ptrs, i32 4, <8 x i1> %m, <8 x float> %passthru)
  ret <8 x float> %v
}

declare <1 x double> @llvm.masked.gather.v1f64.v1p0f64(<1 x double*>, i32, <1 x i1>, <1 x double>)

define <1 x double> @mgather_v1f64(<1 x double*> %ptrs, <1 x i1> %m, <1 x double> %passthru) {
; RV32-LABEL: mgather_v1f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e64, m1, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v1f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e64, m1, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <1 x double> @llvm.masked.gather.v1f64.v1p0f64(<1 x double*> %ptrs, i32 8, <1 x i1> %m, <1 x double> %passthru)
  ret <1 x double> %v
}

declare <2 x double> @llvm.masked.gather.v2f64.v2p0f64(<2 x double*>, i32, <2 x i1>, <2 x double>)

define <2 x double> @mgather_v2f64(<2 x double*> %ptrs, <2 x i1> %m, <2 x double> %passthru) {
; RV32-LABEL: mgather_v2f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e64, m1, tu, mu
; RV32-NEXT:    vluxei32.v v9, (zero), v8, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v2f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e64, m1, tu, mu
; RV64-NEXT:    vluxei64.v v9, (zero), v8, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %v = call <2 x double> @llvm.masked.gather.v2f64.v2p0f64(<2 x double*> %ptrs, i32 8, <2 x i1> %m, <2 x double> %passthru)
  ret <2 x double> %v
}

declare <4 x double> @llvm.masked.gather.v4f64.v4p0f64(<4 x double*>, i32, <4 x i1>, <4 x double>)

define <4 x double> @mgather_v4f64(<4 x double*> %ptrs, <4 x i1> %m, <4 x double> %passthru) {
; RV32-LABEL: mgather_v4f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e64, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (zero), v8, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v4f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e64, m2, tu, mu
; RV64-NEXT:    vluxei64.v v10, (zero), v8, v0.t
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %v = call <4 x double> @llvm.masked.gather.v4f64.v4p0f64(<4 x double*> %ptrs, i32 8, <4 x i1> %m, <4 x double> %passthru)
  ret <4 x double> %v
}

define <4 x double> @mgather_truemask_v4f64(<4 x double*> %ptrs, <4 x double> %passthru) {
; RV32-LABEL: mgather_truemask_v4f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; RV32-NEXT:    vluxei32.v v26, (zero), v8
; RV32-NEXT:    vmv2r.v v8, v26
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_truemask_v4f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; RV64-NEXT:    vluxei64.v v8, (zero), v8
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> undef, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> undef, <4 x i32> zeroinitializer
  %v = call <4 x double> @llvm.masked.gather.v4f64.v4p0f64(<4 x double*> %ptrs, i32 8, <4 x i1> %mtrue, <4 x double> %passthru)
  ret <4 x double> %v
}

define <4 x double> @mgather_falsemask_v4f64(<4 x double*> %ptrs, <4 x double> %passthru) {
; RV32-LABEL: mgather_falsemask_v4f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_falsemask_v4f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vmv2r.v v8, v10
; RV64-NEXT:    ret
  %v = call <4 x double> @llvm.masked.gather.v4f64.v4p0f64(<4 x double*> %ptrs, i32 8, <4 x i1> zeroinitializer, <4 x double> %passthru)
  ret <4 x double> %v
}

declare <8 x double> @llvm.masked.gather.v8f64.v8p0f64(<8 x double*>, i32, <8 x i1>, <8 x double>)

define <8 x double> @mgather_v8f64(<8 x double*> %ptrs, <8 x i1> %m, <8 x double> %passthru) {
; RV32-LABEL: mgather_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, tu, mu
; RV32-NEXT:    vluxei32.v v12, (zero), v8, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (zero), v8, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %v = call <8 x double> @llvm.masked.gather.v8f64.v8p0f64(<8 x double*> %ptrs, i32 8, <8 x i1> %m, <8 x double> %passthru)
  ret <8 x double> %v
}

define <8 x double> @mgather_baseidx_v8i8_v8f64(double* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x double> %passthru) {
; RV32-LABEL: mgather_baseidx_v8i8_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v26, v8
; RV32-NEXT:    vsll.vi v26, v26, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei32.v v12, (a0), v26, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8i8_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <8 x i8> %idxs
  %v = call <8 x double> @llvm.masked.gather.v8f64.v8p0f64(<8 x double*> %ptrs, i32 8, <8 x i1> %m, <8 x double> %passthru)
  ret <8 x double> %v
}

define <8 x double> @mgather_baseidx_sext_v8i8_v8f64(double* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x double> %passthru) {
; RV32-LABEL: mgather_baseidx_sext_v8i8_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsext.vf8 v28, v8
; RV32-NEXT:    vsll.vi v28, v28, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_sext_v8i8_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <8 x i64> %eidxs
  %v = call <8 x double> @llvm.masked.gather.v8f64.v8p0f64(<8 x double*> %ptrs, i32 8, <8 x i1> %m, <8 x double> %passthru)
  ret <8 x double> %v
}

define <8 x double> @mgather_baseidx_zext_v8i8_v8f64(double* %base, <8 x i8> %idxs, <8 x i1> %m, <8 x double> %passthru) {
; RV32-LABEL: mgather_baseidx_zext_v8i8_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vzext.vf8 v28, v8
; RV32-NEXT:    vsll.vi v28, v28, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_zext_v8i8_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf8 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <8 x i64> %eidxs
  %v = call <8 x double> @llvm.masked.gather.v8f64.v8p0f64(<8 x double*> %ptrs, i32 8, <8 x i1> %m, <8 x double> %passthru)
  ret <8 x double> %v
}

define <8 x double> @mgather_baseidx_v8i16_v8f64(double* %base, <8 x i16> %idxs, <8 x i1> %m, <8 x double> %passthru) {
; RV32-LABEL: mgather_baseidx_v8i16_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf2 v26, v8
; RV32-NEXT:    vsll.vi v26, v26, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei32.v v12, (a0), v26, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8i16_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <8 x i16> %idxs
  %v = call <8 x double> @llvm.masked.gather.v8f64.v8p0f64(<8 x double*> %ptrs, i32 8, <8 x i1> %m, <8 x double> %passthru)
  ret <8 x double> %v
}

define <8 x double> @mgather_baseidx_sext_v8i16_v8f64(double* %base, <8 x i16> %idxs, <8 x i1> %m, <8 x double> %passthru) {
; RV32-LABEL: mgather_baseidx_sext_v8i16_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v28, v8
; RV32-NEXT:    vsll.vi v28, v28, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_sext_v8i16_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %eidxs = sext <8 x i16> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <8 x i64> %eidxs
  %v = call <8 x double> @llvm.masked.gather.v8f64.v8p0f64(<8 x double*> %ptrs, i32 8, <8 x i1> %m, <8 x double> %passthru)
  ret <8 x double> %v
}

define <8 x double> @mgather_baseidx_zext_v8i16_v8f64(double* %base, <8 x i16> %idxs, <8 x i1> %m, <8 x double> %passthru) {
; RV32-LABEL: mgather_baseidx_zext_v8i16_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vzext.vf4 v28, v8
; RV32-NEXT:    vsll.vi v28, v28, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_zext_v8i16_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf4 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %eidxs = zext <8 x i16> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <8 x i64> %eidxs
  %v = call <8 x double> @llvm.masked.gather.v8f64.v8p0f64(<8 x double*> %ptrs, i32 8, <8 x i1> %m, <8 x double> %passthru)
  ret <8 x double> %v
}

define <8 x double> @mgather_baseidx_v8i32_v8f64(double* %base, <8 x i32> %idxs, <8 x i1> %m, <8 x double> %passthru) {
; RV32-LABEL: mgather_baseidx_v8i32_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsll.vi v26, v8, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei32.v v12, (a0), v26, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8i32_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf2 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <8 x i32> %idxs
  %v = call <8 x double> @llvm.masked.gather.v8f64.v8p0f64(<8 x double*> %ptrs, i32 8, <8 x i1> %m, <8 x double> %passthru)
  ret <8 x double> %v
}

define <8 x double> @mgather_baseidx_sext_v8i32_v8f64(double* %base, <8 x i32> %idxs, <8 x i1> %m, <8 x double> %passthru) {
; RV32-LABEL: mgather_baseidx_sext_v8i32_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v28, v8
; RV32-NEXT:    vsll.vi v28, v28, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_sext_v8i32_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf2 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %eidxs = sext <8 x i32> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <8 x i64> %eidxs
  %v = call <8 x double> @llvm.masked.gather.v8f64.v8p0f64(<8 x double*> %ptrs, i32 8, <8 x i1> %m, <8 x double> %passthru)
  ret <8 x double> %v
}

define <8 x double> @mgather_baseidx_zext_v8i32_v8f64(double* %base, <8 x i32> %idxs, <8 x i1> %m, <8 x double> %passthru) {
; RV32-LABEL: mgather_baseidx_zext_v8i32_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vzext.vf2 v28, v8
; RV32-NEXT:    vsll.vi v28, v28, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_zext_v8i32_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf2 v28, v8
; RV64-NEXT:    vsll.vi v28, v28, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %eidxs = zext <8 x i32> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <8 x i64> %eidxs
  %v = call <8 x double> @llvm.masked.gather.v8f64.v8p0f64(<8 x double*> %ptrs, i32 8, <8 x i1> %m, <8 x double> %passthru)
  ret <8 x double> %v
}

define <8 x double> @mgather_baseidx_v8f64(double* %base, <8 x i64> %idxs, <8 x i1> %m, <8 x double> %passthru) {
; RV32-LABEL: mgather_baseidx_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsll.vi v28, v8, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV32-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV32-NEXT:    vmv4r.v v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsll.vi v28, v8, 3
; RV64-NEXT:    vsetvli zero, zero, e64, m4, tu, mu
; RV64-NEXT:    vluxei64.v v12, (a0), v28, v0.t
; RV64-NEXT:    vmv4r.v v8, v12
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <8 x i64> %idxs
  %v = call <8 x double> @llvm.masked.gather.v8f64.v8p0f64(<8 x double*> %ptrs, i32 8, <8 x i1> %m, <8 x double> %passthru)
  ret <8 x double> %v
}

declare <16 x i8> @llvm.masked.gather.v16i8.v16p0i8(<16 x i8*>, i32, <16 x i1>, <16 x i8>)

define <16 x i8> @mgather_baseidx_v16i8(i8* %base, <16 x i8> %idxs, <16 x i1> %m, <16 x i8> %passthru) {
; RV32-LABEL: mgather_baseidx_v16i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v28, v8
; RV32-NEXT:    vsetvli zero, zero, e8, m1, tu, mu
; RV32-NEXT:    vluxei32.v v9, (a0), v28, v0.t
; RV32-NEXT:    vmv1r.v v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v16i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v8
; RV64-NEXT:    vsetvli zero, zero, e8, m1, tu, mu
; RV64-NEXT:    vluxei64.v v9, (a0), v16, v0.t
; RV64-NEXT:    vmv1r.v v8, v9
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i8, i8* %base, <16 x i8> %idxs
  %v = call <16 x i8> @llvm.masked.gather.v16i8.v16p0i8(<16 x i8*> %ptrs, i32 2, <16 x i1> %m, <16 x i8> %passthru)
  ret <16 x i8> %v
}

declare <32 x i8> @llvm.masked.gather.v32i8.v32p0i8(<32 x i8*>, i32, <32 x i1>, <32 x i8>)

define <32 x i8> @mgather_baseidx_v32i8(i8* %base, <32 x i8> %idxs, <32 x i1> %m, <32 x i8> %passthru) {
; RV32-LABEL: mgather_baseidx_v32i8:
; RV32:       # %bb.0:
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; RV32-NEXT:    vsext.vf4 v16, v8
; RV32-NEXT:    vsetvli zero, zero, e8, m2, tu, mu
; RV32-NEXT:    vluxei32.v v10, (a0), v16, v0.t
; RV32-NEXT:    vmv2r.v v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mgather_baseidx_v32i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vmv1r.v v25, v0
; RV64-NEXT:    vsetivli zero, 16, e8, m2, ta, mu
; RV64-NEXT:    vslidedown.vi v26, v10, 16
; RV64-NEXT:    vslidedown.vi v28, v8, 16
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v28
; RV64-NEXT:    vsetivli zero, 2, e8, mf4, ta, mu
; RV64-NEXT:    vslidedown.vi v0, v0, 2
; RV64-NEXT:    vsetivli zero, 16, e8, m1, tu, mu
; RV64-NEXT:    vluxei64.v v26, (a0), v16, v0.t
; RV64-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v8
; RV64-NEXT:    vsetvli zero, zero, e8, m1, tu, mu
; RV64-NEXT:    vmv1r.v v0, v25
; RV64-NEXT:    vluxei64.v v10, (a0), v16, v0.t
; RV64-NEXT:    addi a0, zero, 32
; RV64-NEXT:    vsetvli zero, a0, e8, m2, ta, mu
; RV64-NEXT:    vmv.v.i v8, 0
; RV64-NEXT:    vsetivli zero, 16, e8, m2, tu, mu
; RV64-NEXT:    vslideup.vi v8, v10, 0
; RV64-NEXT:    vsetvli zero, a0, e8, m2, tu, mu
; RV64-NEXT:    vslideup.vi v8, v26, 16
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i8, i8* %base, <32 x i8> %idxs
  %v = call <32 x i8> @llvm.masked.gather.v32i8.v32p0i8(<32 x i8*> %ptrs, i32 2, <32 x i1> %m, <32 x i8> %passthru)
  ret <32 x i8> %v
}
