; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -indvars -instcombine -S < %s | FileCheck %s

;; Test that loop's exit value is rewritten to its initial
;; value from loop preheader
define i32 @test1(i32* %var) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32* [[VAR:%.*]], null
; CHECK-NEXT:    br label [[HEADER:%.*]]
; CHECK:       header:
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP:%.*]], label [[EXIT:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    br label [[HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 0
;
entry:
  %cond = icmp eq i32* %var, null
  br label %header

header:
  %phi_indvar = phi i32 [0, %entry], [%indvar, %loop]
  br i1 %cond, label %loop, label %exit

loop:
  %indvar = add i32 %phi_indvar, 1
  br label %header

exit:
  ret i32 %phi_indvar
}

;; Test that we can not rewrite loop exit value if it's not
;; a phi node (%indvar is an add instruction in this test).
define i32 @test2(i32* %var) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32* [[VAR:%.*]], null
; CHECK-NEXT:    br label [[HEADER:%.*]]
; CHECK:       header:
; CHECK-NEXT:    [[PHI_INDVAR:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INDVAR:%.*]], [[HEADER]] ]
; CHECK-NEXT:    [[INDVAR]] = add i32 [[PHI_INDVAR]], 1
; CHECK-NEXT:    br i1 [[COND]], label [[HEADER]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 [[INDVAR]]
;
entry:
  %cond = icmp eq i32* %var, null
  br label %header

header:
  %phi_indvar = phi i32 [0, %entry], [%indvar, %header]
  %indvar = add i32 %phi_indvar, 1
  br i1 %cond, label %header, label %exit

exit:
  ret i32 %indvar
}

;; Test that we can not rewrite loop exit value if the condition
;; is not in loop header.
define i32 @test3(i32* %var) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COND1:%.*]] = icmp eq i32* [[VAR:%.*]], null
; CHECK-NEXT:    br label [[HEADER:%.*]]
; CHECK:       header:
; CHECK-NEXT:    [[PHI_INDVAR:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INDVAR:%.*]], [[HEADER_BACKEDGE:%.*]] ]
; CHECK-NEXT:    [[INDVAR]] = add i32 [[PHI_INDVAR]], 1
; CHECK-NEXT:    [[COND2:%.*]] = icmp eq i32 [[INDVAR]], 10
; CHECK-NEXT:    br i1 [[COND2]], label [[HEADER_BACKEDGE]], label [[BODY:%.*]]
; CHECK:       header.backedge:
; CHECK-NEXT:    br label [[HEADER]]
; CHECK:       body:
; CHECK-NEXT:    br i1 [[COND1]], label [[HEADER_BACKEDGE]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 [[PHI_INDVAR]]
;
entry:
  %cond1 = icmp eq i32* %var, null
  br label %header

header:
  %phi_indvar = phi i32 [0, %entry], [%indvar, %header], [%indvar, %body]
  %indvar = add i32 %phi_indvar, 1
  %cond2 = icmp eq i32 %indvar, 10
  br i1 %cond2, label %header, label %body

body:
  br i1 %cond1, label %header, label %exit

exit:
  ret i32 %phi_indvar
}


; Multiple exits dominating latch
define i32 @test4(i1 %cond1, i1 %cond2) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[HEADER:%.*]]
; CHECK:       header:
; CHECK-NEXT:    br i1 [[COND1:%.*]], label [[LOOP:%.*]], label [[EXIT:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    br i1 [[COND2:%.*]], label [[HEADER]], label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 0
;
entry:
  br label %header

header:
  %phi_indvar = phi i32 [0, %entry], [%indvar, %loop]
  br i1 %cond1, label %loop, label %exit

loop:
  %indvar = add i32 %phi_indvar, 1
  br i1 %cond2, label %header, label %exit

exit:
  ret i32 %phi_indvar
}

; A conditionally executed exit.
define i32 @test5(i1* %addr, i1 %cond2) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[HEADER:%.*]]
; CHECK:       header:
; CHECK-NEXT:    [[PHI_INDVAR:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INDVAR:%.*]], [[LOOP:%.*]] ]
; CHECK-NEXT:    [[COND1:%.*]] = load volatile i1, i1* [[ADDR:%.*]], align 1
; CHECK-NEXT:    br i1 [[COND1]], label [[LOOP]], label [[MAYBE:%.*]]
; CHECK:       maybe:
; CHECK-NEXT:    br i1 [[COND2:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVAR]] = add i32 [[PHI_INDVAR]], 1
; CHECK-NEXT:    br label [[HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 [[PHI_INDVAR]]
;
entry:
  br label %header

header:
  %phi_indvar = phi i32 [0, %entry], [%indvar, %loop]
  %cond1 = load volatile i1, i1* %addr
  br i1 %cond1, label %loop, label %maybe

maybe:
  br i1 %cond2, label %loop, label %exit

loop:
  %indvar = add i32 %phi_indvar, 1
  br label %header

exit:
  ret i32 %phi_indvar
}


