/*
 * BRLTTY - A background process providing access to the console screen (when in
 *          text mode) for a blind person using a refreshable braille display.
 *
 * Copyright (C) 1995-2019 by The BRLTTY Developers.
 *
 * BRLTTY comes with ABSOLUTELY NO WARRANTY.
 *
 * This is free software, placed under the terms of the
 * GNU Lesser General Public License, as published by the Free Software
 * Foundation; either version 2.1 of the License, or (at your option) any
 * later version. Please see the file LICENSE-LGPL for details.
 *
 * Web Page: http://brltty.app/
 *
 * This software is maintained by Dave Mielke <dave@mielke.cc>.
 */

#ifndef BRLTTY_INCLUDED_STDIOX
#define BRLTTY_INCLUDED_STDIOX

#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

static inline void
flushStream (FILE *stream) {
  fflush(stream);

#ifdef __MSDOS__
  fsync(fileno(stream));
#endif /* __MSDOS__ */
}

#if defined(_POSIX_THREAD_SAFE_FUNCTIONS) && !defined(__MINGW32__)
#define lockStream(stream) flockfile((stream))
#define unlockStream(stream) funlockfile((stream))
#else /* _POSIX_THREAD_SAFE_FUNCTIONS */
#define lockStream(stream)
#define unlockStream(stream)
#endif /* _POSIX_THREAD_SAFE_FUNCTIONS */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* BRLTTY_INCLUDED_STDIOX */
